'/***************************************************************************/
'/**                                                                       **/
'/**                               MAGICARD                                **/
'/**                                                                       **/
'/***************************************************************************/
'/**                                                                       **/
'/**  PROJECT      : SDK VB Demo - DTC Printers                            **/
'/**                                                                       **/
'/**  MODULE NAME  : Info.vb                                               **/
'/**                                                                       **/
'/**  COPYRIGHT    : Magicard                                              **/
'/**                                                                       **/
'/***************************************************************************/
Partial Public Class Main

#Region "=== Local methods ==="

    Private Sub InitUtilsTab()

    End Sub

    Private Sub ClearUtilsMsgBoxButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) _
                Handles ClearUtilsMsgBoxButton.Click
        UtilsMsgBox.Clear()
    End Sub

#End Region

    '----------------------------------------------------------------------

#Region "=== Single Line Encoding ==="

    Private Sub SendAPDUButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) _
                Handles SendAPDUButton.Click

        Cursor.Current = Cursors.WaitCursor
        Dim tempString As String = ""


        If SendAPDUBox.Text.Length = 0 Then
            MessageBox.Show("APDU Box is empty")
        Else

            Dim APDUList As List(Of String) = New List(Of String)(SendAPDUBox.Text.Split({"\r\n", "\n"}, StringSplitOptions.RemoveEmptyEntries))

            For Each apdu As String In APDUList

                UtilsMsgBox.AppendText("APDU Sent -> " + apdu + Environment.NewLine)
                UtilsMsgBox.AppendText(Environment.NewLine)

                Dim APDUReturn As StringBuilder = New StringBuilder()
                Dim APDUInput As StringBuilder = New StringBuilder(apdu)

                Dim SDKReturn As SDK.Return = SDK.ID_SendAPDU(hSession, APDUInput, APDUReturn)
                If SDKReturn <> SDK.Return.Success Then
                    HandleError("SendAPDU", SDKReturn)
                Else
                    tempString = APDUReturn.ToString

                    UtilsMsgBox.AppendText("APDU Reply: " + tempString + Environment.NewLine)
                    UtilsMsgBox.AppendText(Environment.NewLine)
                End If

            Next

            
        End If

        Cursor.Current = Cursors.Default
    End Sub

#End Region

    '----------------------------------------------------------------------

End Class
